definition module clCrossCall

import intrface, StdEnv


  //----------------------------------------------//
 //    Cursor related crosscalls                 //
//----------------------------------------------//

WinSetWindowCursor :: !HWND !Int !*OSToolbox -> *OSToolbox
WinObscureCursor :: !*OSToolbox -> *OSToolbox


  //----------------------------------------------//
 //    Dialog related crosscalls                 //
//----------------------------------------------//

WinBeep :: !*OSToolbox -> *OSToolbox
WinShowControl :: !HWND !Bool !*OSToolbox -> *OSToolbox		// PA: new routine to hide (False) & show (True) controls.
WinEnableControl :: !HWND !Bool !*OSToolbox -> *OSToolbox
WinEnablePopupItem :: !HWND !Int !Bool !*OSToolbox -> *OSToolbox
WinCheckControl  :: !HWND !Bool !*OSToolbox -> *OSToolbox
WinSelectPopupItem :: !HWND !Int !*OSToolbox -> *OSToolbox


  //----------------------------------------------//
 //    Timer related crosscalls                  //
//----------------------------------------------//

WinCreateTimer :: !Int !*OSToolbox -> (!HITEM, !*OSToolbox)
WinKillTimer :: !Int !*OSToolbox -> *OSToolbox
WinSetIdleTimer :: !Bool !*OSToolbox -> *OSToolbox
WinGetTime :: !*OSToolbox -> (!(!Int,!Int,!Int),!*OSToolbox)
WinGetDate :: !*OSToolbox -> (!(!Int,!Int,!Int,!Int),!*OSToolbox)
WinWait :: !Int !*OSToolbox -> *OSToolbox
WinGetBlinkTime :: !*OSToolbox -> (!Int,!*OSToolbox)

  //----------------------------------------------//
 //    Clipboard related crosscalls              //
//----------------------------------------------//

WinGetClipboardText :: !*OSToolbox -> (!String, !*OSToolbox)
WinSetClipboardText :: !String !*OSToolbox -> *OSToolbox
WinHasClipboardText :: !*OSToolbox -> (!Bool,!*OSToolbox)

  //----------------------------------------------//
 //    Window related crosscalls                 //
//----------------------------------------------//

WinSetWindowTitle :: !HWND !String !*OSToolbox -> *OSToolbox
WinGetWindowText  :: !HWND !*OSToolbox -> (!String, !*OSToolbox)
WinInvalidateWindow :: !HWND !*OSToolbox -> *OSToolbox
//	PA: new function to invalidate portion of window/control:
WinInvalidateRect :: !HWND !(!Int,!Int,!Int,!Int) !*OSToolbox -> *OSToolbox
//	PA: new function to (en/dis)able windows.
WinSetSelectStateWindow :: !HWND !(!Bool,!Bool) !Bool !Bool !*OSToolbox -> *OSToolbox
WinBeginPaint :: !HWND        !*OSToolbox -> (!HDC, !*OSToolbox) 
WinEndPaint   :: !HWND !(!HDC, !*OSToolbox) -> *OSToolbox
WinGetDC :: !HWND !*OSToolbox -> (!HDC, !*OSToolbox) 
WinReleaseDC :: !HWND !(!HDC, !*OSToolbox) -> *OSToolbox
WinGetActiveDialog     :: !*OSToolbox -> (!HWND, !*OSToolbox)
WinGetForegroundWindow :: !*OSToolbox -> (!HWND, !*OSToolbox)
WinSetScrollInfos :: !HWND !(!(!Int,!Int),!(!Int,!Int)) !(!Int,!Int,!Int,!Int) !*OSToolbox -> *OSToolbox
WinGetClientSize :: !HWND !*OSToolbox -> ( !(!Int,!Int), !*OSToolbox)
WinSetWindowSize :: !HWND !(!Int,!Int) !*OSToolbox -> *OSToolbox		// PA: added
WinGetWindowPos :: !HWND !*OSToolbox -> (!(!Int,!Int), !*OSToolbox)
WinSetWindowPos :: !HWND !(!Int,!Int) !*OSToolbox -> *OSToolbox
WinGetScrollWinFrameSize :: !HWND !*OSToolbox -> ( !(!Int,!Int), !*OSToolbox)
/*	PA: three new functions to handle scrollbars.
*/
WinSetScrollRange :: !HWND !Int !Int !Int !Bool !*OSToolbox -> *OSToolbox
WinSetScrollPos :: !HWND !Int !Int !Bool !*OSToolbox -> *OSToolbox
WinSetScrollThumbSize :: !HWND !Int !Int !Bool !*OSToolbox -> *OSToolbox
/*	PA: new functions to handle edit controls.
*/
WinSetEditSelection :: !HWND !Int !Int !*OSToolbox -> *OSToolbox		// Note: @2<=@3, @1 must point to an edit control.
/*	PA: WinRestackWindow now as a crosscall operation.
*/
WinRestackWindow :: !HWND !HWND !*OSToolbox -> *OSToolbox	// PA: new function to put first window behind second window


  //----------------------------------------------//
 //    Menu related crosscalls                   //
//----------------------------------------------//

WinCreateMenuBarHandle	::										!*OSToolbox -> (!HMENU, !*OSToolbox)
WinCreateMenuWindow		:: !HMENU !String						!*OSToolbox -> (!HWND,  !*OSToolbox)
WinCreatePopupMenuHandle::										!*OSToolbox -> (!HMENU, !*OSToolbox)
WinInsertMenu			:: !String !Bool !HMENU !HMENU !Int		!*OSToolbox -> *OSToolbox
WinAppendMenu			:: !String !Bool !HMENU !HMENU			!*OSToolbox -> *OSToolbox
WinAppendMenuItem       :: !String !Bool !Bool !HMENU			!*OSToolbox -> (!HITEM, !*OSToolbox)
WinAppendSeparator		:: !HMENU								!*OSToolbox -> *OSToolbox
WinInsertMenuItem       :: !String !Bool !Bool !HMENU !Int		!*OSToolbox -> (!HITEM, !*OSToolbox)
WinInsertSeparator		:: !HMENU !Int							!*OSToolbox -> *OSToolbox
WinChangeMenuItemCheck  :: !HMENU !HITEM !Bool					!*OSToolbox -> *OSToolbox
WinModifyMenu			:: !String !HMENU !HMENU				!*OSToolbox -> *OSToolbox
WinModifyMenuItem       :: !String !HITEM !HMENU				!*OSToolbox -> *OSToolbox
WinDestroyMenu			:: !HMENU								!*OSToolbox -> *OSToolbox	// PA: new as crosscall
WinDeleteMenu			:: !HMENU !HITEM						!*OSToolbox -> *OSToolbox	// PA: new as crosscall
WinRemoveMenuItem       :: !HMENU !HITEM						!*OSToolbox -> *OSToolbox
WinChangeItemAbility    :: !HMENU !HITEM !Bool					!*OSToolbox -> *OSToolbox
WinChangeMenuAbility	:: !HMENU !Int   !Bool					!*OSToolbox -> *OSToolbox
WinDrawMenuBar			::										!*OSToolbox -> *OSToolbox

  //----------------------------------------------//
 //    Crosscall infrastructure                  //
//----------------------------------------------//

//	Crosscall with state parameter:
ErrorCallback :: !String !CrossCallInfo !.s !*OSToolbox -> (!CrossCallInfo,!.s,!*OSToolbox)
IssueCleanRequest :: !(CrossCallInfo -> .(.s -> .(*OSToolbox -> *(.CrossCallInfo,.s,*OSToolbox))))
					 !.CrossCallInfo
					 !.s
					 !*OSToolbox
				  -> (!CrossCallInfo,!.s,!*OSToolbox)

//	Crosscall without state parameter:
ErrorCallback2 :: !String !CrossCallInfo !*OSToolbox -> (!CrossCallInfo,!*OSToolbox)
IssueCleanRequest2 :: !(CrossCallInfo -> .(*OSToolbox -> *(.CrossCallInfo,*OSToolbox)))
					 !.CrossCallInfo
					 !*OSToolbox
				  -> (!CrossCallInfo,!*OSToolbox)

//	PA: macros for returning proper number of arguments within a CrossCallInfo.
Rq0Cci msg :== {ccMsg=msg,p1=0,p2=0,p3=0,p4=0,p5=0,p6=0}
Rq1Cci msg v1 :== {ccMsg=msg,p1=v1,p2=0,p3=0,p4=0,p5=0,p6=0}
Rq2Cci msg v1 v2 :== {ccMsg=msg,p1=v1,p2=v2,p3=0,p4=0,p5=0,p6=0}
Rq3Cci msg v1 v2 v3 :== {ccMsg=msg,p1=v1,p2=v2,p3=v3,p4=0,p5=0,p6=0}
Rq4Cci msg v1 v2 v3 v4 :== {ccMsg=msg,p1=v1,p2=v2,p3=v3,p4=v4,p5=0,p6=0}
Rq5Cci msg v1 v2 v3 v4 v5 :== {ccMsg=msg,p1=v1,p2=v2,p3=v3,p4=v4,p5=v5,p6=0}
Rq6Cci msg v1 v2 v3 v4 v5 v6 :== {ccMsg=msg,p1=v1,p2=v2,p3=v3,p4=v4,p5=v5,p6=v6}

Return0Cci   ::				                     CrossCallInfo
Return1Cci   :: !Int			              -> CrossCallInfo
Return2Cci   :: !Int !Int		              -> CrossCallInfo
Return3Cci   :: !Int !Int !Int                -> CrossCallInfo
Return4Cci   :: !Int !Int !Int !Int           -> CrossCallInfo
Return5Cci   :: !Int !Int !Int !Int !Int      -> CrossCallInfo
Return6Cci   :: !Int !Int !Int !Int !Int !Int -> CrossCallInfo


  //----------------------------------------------//
 //  Showing messages, and printing to stdout    //
//----------------------------------------------//

Ibeep :: .a -> .a
// Iprint string a :== a
// Iprint` string a :== a
Iprint  :: !String !.a -> .a
Iprint` :: !String !.a -> .a

instance toInt Bool
